/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.api.IGlStateManager;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.client.renderer.ModelBuffer;
import org.lwjgl.opengl.GL11;

public class WrapperGlStateManager
implements IGlStateManager {
    private final Minecraft minecraft;

    public WrapperGlStateManager(Minecraft mc) {
        this.minecraft = mc;
    }

    @Override
    public void enableBlend() {
        GlStateManager.func_179147_l();
    }

    @Override
    public void disableBlend() {
        GlStateManager.func_179084_k();
    }

    @Override
    public void enableAlpha() {
        GlStateManager.func_179141_d();
    }

    @Override
    public void disableAlpha() {
        GlStateManager.func_179118_c();
    }

    @Override
    public void pushMatrix() {
        GlStateManager.func_179094_E();
    }

    @Override
    public void popMatrix() {
        GlStateManager.func_179121_F();
    }

    @Override
    public void color(float red, float green, float blue, float alpha) {
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    @Override
    public void translate(float x, float y, float z) {
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
    }

    @Override
    public void scale(float x, float y, float z) {
        GlStateManager.func_179152_a((float)x, (float)y, (float)z);
    }

    @Override
    public void rotate(float angle, float axisX, float axisY, float axisZ) {
        GlStateManager.func_179114_b((float)angle, (float)axisX, (float)axisY, (float)axisZ);
    }

    @Override
    public void drawString(String text, float x, float y, int color, boolean dropShadow) {
        if (text == null || !text.isEmpty()) {
            return;
        }
        this.minecraft.field_71466_p.func_175065_a(text, x, y, color, dropShadow);
    }

    @Override
    public void draw(double left, double top, double width, double height, int color, float alpha) {
        this.draw(left, top, width, height, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, alpha);
    }

    @Override
    public void draw(double left, double top, double width, double height, float red, float green, float blue, float alpha) {
        if (alpha <= 0.0f) {
            return;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        if (red < 0.0f) {
            red = 0.0f;
        } else if (red > 1.0f) {
            red = 1.0f;
        }
        if (green < 0.0f) {
            green = 0.0f;
        } else if (green > 1.0f) {
            green = 1.0f;
        }
        if (blue < 0.0f) {
            blue = 0.0f;
        } else if (blue > 1.0f) {
            blue = 1.0f;
        }
        double right = left + width;
        double bottom = top + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b(left, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(left, top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @Override
    public void drawTexture(String resourceLocation, double x, double y, double z, double u, double v, double width, double height, boolean revers) {
        if (resourceLocation == null || resourceLocation.isEmpty()) {
            return;
        }
        ResourceLocation loc = new ResourceLocation(resourceLocation);
        this.minecraft.func_110434_K().func_110577_a(loc);
        this.minecraft.func_110434_K().func_110581_b(loc);
        float w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        float h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        if (w > 256.0f) {
            w = 256.0f;
            width *= (double)(256.0f / w);
        }
        if (h > 256.0f) {
            h = 256.0f;
            height *= (double)(256.0f / h);
        }
        float f = 1.0f / w;
        float f1 = 1.0f / h;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double us = (revers ? u + width : u) * (double)f;
        double ue = (revers ? u : u + width) * (double)f;
        bufferbuilder.func_181662_b(x, y + height, z).func_187315_a(us, (v + height) * (double)f1).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, z).func_187315_a(ue, (v + height) * (double)f1).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, z).func_187315_a(ue, v * (double)f1).func_181675_d();
        bufferbuilder.func_181662_b(x, y, z).func_187315_a(us, v * (double)f1).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void renderEntity(Object entity, double x, double y, double z, float yaw, float partialTicks, boolean disableDebugBoundingBox) {
        if (entity instanceof Entity) {
            this.minecraft.func_175598_ae().func_188391_a((Entity)entity, x, y, z, yaw, partialTicks, disableDebugBoundingBox);
        } else if (entity instanceof IEntity) {
            this.minecraft.func_175598_ae().func_188391_a(((IEntity)entity).getMCEntity(), x, y, z, yaw, partialTicks, disableDebugBoundingBox);
        }
    }

    @Override
    public void drawOBJ(String resourseLocation) {
        if (resourseLocation == null || !resourseLocation.isEmpty()) {
            return;
        }
        int displayList = ModelBuffer.getDisplayList(new ResourceLocation(resourseLocation), null, null);
        if (displayList > 0) {
            this.minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GL11.glEnable((int)2929);
            GlStateManager.func_179148_o((int)displayList);
        }
    }
}

